; 01 Multiply everything by 2.

NPLANES equ 9

org 100h        ; assume al=0 bx=0 sp=di=-2 si=0100h bp=09??h; last 16 bytes of PSP = 0
   db 0x04,0xC3 ;=mov al,0xC3
RO equ $-4*3    ; dd 0.0, -32.0, -128.0
I:mov byte[byte RO+4+3 + si-100h],0xC2

;Video mode + palette: 4 bits orange * 4 bits blue. Uses default index 0 (black).
BIG equ $-1
  pusha
  mov al,13h
P:int 10h       ; set video mode | set palette index: bx=i dh=R ch=G cl=B

;  inc bx
;  mov al,bl
;  aam 16        ; ax = ....rrrr....bbbb
;BIG equ $-1
;  imul dx,ax,4
;  mov ax,1010h
;  mov cx,dx
;  add ch,cl
;  shr ch,1      ; ch=G = (R+B)/2
;  jnz P         ; dx=cx=0 bx=100h ax=1010h

;  mov dx,3c8h  ; gray
;  out dx,al
;  inc dx
;Q:out dx,al
;  out dx,al
;  out dx,al
;  inc ax
;  jnz Q

  popa
  dec di        ; di = pixel address = -3

M:mov dx,0xA000-10-20-20-4;  ; visible pixels are A0000..AF9FF: want X=0 Y=0 in the center of the screen
  mov es,dx     ; dx:bx=YX:XX = es:0     must be neighbors after PUSHA

GEN_GEM:
  pusha
  xor ax,ax
  fld1
  fldz
  fldz
PL:
  add bp,si ; gem planes are at [bp+200h,300h,...]
  pusha
  mov bx,4
RR:
  call STORE                   ;|y x z         ;|x Y Z
  fild word[di-3] ;di=-3       ;|T
  fidiv word[C16-2+bx+si-100h] ;|T/100         ;|T/16
  call LOAD_ROTATE             ;|x Y,Z=R(y,z)  ;|Y XX,ZZ=r(x,Z)
  dec bx
  dec bx
  jnz RR
  fxch st1
  call NORMALIZE
  call STORE
GG:         ; di=-3
  fld1      ;|a b c -> b c a
  shr ax,1
  jnc GNC
  fchs
GNC:
  inc di
  jnz GG
  popa
  inc ax
  cmp al,NPLANES
  jne PL
  popa

X:   ;cx=T di=adr_pixel(init=0) bp=09?? si=0100 ah=0   ; cf=0
  inc dx
X2:
  fninit        ; adr:     -18 -16 -14 -12 -10  -8  -6  -4  -2
  pusha         ; stack:    di  si  bp  sp  bx  dx  cx  ax   0
  xor bx,bx     ; s16:  pixadr 100 9??  -2  ..X..Y  T (result)

  fild word[byte BIG + si-100h] ; Z=27000
  fild word[bx-8]  ; Y
  fisub word[si]       ; -13000
  fild word[bx-9]  ; X   |rD.xyz p.d
  call NORMALIZE ;bx=bp
  call STORE

  mov dx,RO-0x100
  call GEM_OUTER   ;|ro[dx] rd[bp] --> cf=1_if_hit di=address_of_hit_facet   ; clobbers ax,bx,cx
  mov bx,-6
  mov [bx+6-4],di  ;pushed ax
  jnc NO_GEM_HIT
  popa
  jmp SK

NO_GEM_HIT:
  fild word[CG + si-100h]
  fdiv dword[bp+si+4] ;|t=(N=pd-(-ro.y))/(D=-rd.y) = -64 / -rd.y = 64/rd.y
  ftst
  fnstsw ax
  sahf             ; cf=0 if hit
  call LOAD_SCALE  ;|(t*rd).x .y .z   (assume ro=0 for the ground)
  call STORE
  fild word[bx+6-6]
  fidiv word[C100] ;|T/100
  call LOAD_ROTATE ;|y R(x,z)

  fstp st0          ; h = {ro + rd*t}; we need only x and z (+ no need to add ro)
  fistp word[bp+si] ;V = s16(h.x)
  fistp word[bx+6-4] ; pushed_ax = s16(h.z + 2*T)
  popa
  jb  S
  add al,cl
  add al,cl
  xor al,[bp+si]
  shr al,5
;  db 0xA8
S:salc
SK:not al
  shr al,4
  add al,16
  stosb

;  stosb        ; doubled pixels - faster
;  add bx,0xCCCD ;dx:bx = YXX += 0000CCCD
;  adc dx,0

  add bx,0xCCCD ;dx:bx = YXX += 0000CCCD
  jnc X2
  jnz X   ;do 65536 iterations

  inc cx  ; T++
  in al,60h
  dec al
  jnz M
 ;ret     ; fallthrough

NORMALIZE:  ; { a.x a.y a.z } --> { n.x n.y n.z } a[bp](unnormalized) bx=bp
  call STORE        ;|a*a   ; [bp]=a (unnormalized)
  mov bx,bp
  call DOT          ;|a*a   ; [bp]=a (unnormalized)
  fsqrt
  fld1
  fdivrp st1        ;|rsqrt(a*a)        ...    will be: |rd.x rd.y rd.z
LOAD_SCALE: ; { k } a[bp] --> { k*x k*y k*z }
  fld dword[bp+si+4]
  fmul st1           ;|ky k
LOAD_SCALE_XZ:
  fld dword[bp+si+8]
  fmul st2
  fxch st2           ;|k ky kz
  fmul dword[bp+si]  ;|kx ky kz
  ret

LOAD_ROTATE: ; { angle } a[bp] --> { y R(x,z) }
  fsincos            ;| c s
LOAD_ROTATE_CS: ; { c s } a[bp] --> { y R(x,z) }
  call LOAD_SCALE_XZ ;| sx c sz
  call LOAD_SCALE_XZ ;| cx sx cz sz
  fsubp st3,st0      ;| sx cz sz-cx
  faddp              ;| sx+cz sz-cx
  fld dword[bp+si+4] ;| y sx+cz sz-cx
  ret

STORE: ; { a.x a.y a.z } --> a[bp]
  fstp dword[bp+si]
  fstp dword[bp+si+4]
  fstp dword[bp+si+8]
  ret

DOT:  ; a[bp] b[bx] --> { a.x*b.x+a.y*b.y+a.z*b.z }
  fld dword[bp+si]
  fmul dword[bx+si]
  fld dword[bp+si+4]
  fmul dword[bx+si+4]
  faddp
  fld dword[bp+si+8]
  fmul dword[bx+si+8]
  faddp
  ret

;RAY_PARAM: ; { t } rd[bp] ro[dx] --> { (ro+rd*t).xyz }
;  call LOAD_SCALE ;|rd*t
;  xchg bp,dx
;  fld dword[bp+si+8]
;  faddp st3
;  fld dword[bp+si+4]
;  faddp st2
;  fadd dword[bp+si]
;  xchg bp,dx
;  ret


;BACKGROUND:
;
;
;SCENE:  ; { rd.x rd.y rd.z } ro[ax] --> color[bp+4]
;  call GEM        ; cf=1 if hit; ax=face, [bp+8]=d|p[face],
;  jnc BACKGROUND
;  fld [IOR]


;  v3 hitpos;
;  int face = ray_gem_outer(r, &hitpos);
;  if (no hit) {
;    return ray_background(r);
;  }
;  else {
;    float R = fresnel(ior, -(r.d|p[face].n));
;    ray rr{hitpos, reflect(r.d, p[face].n)};
;    float color = R * ray_background(rr);
;    if (R < 1) {
;      ray rt{hitpos, refract(r.d, p[face].n, 1.f/ior)};
;      color += (1-R) * ray_gem_inner(rt, face);
;    }
;    return color;
;  }

GEM_OUTER: ; ro[dx] rd[bp] --> cf=1_if_hit di=address_of_hit_facet   ; clobbers ax,bx,cx
  fild dword[si]  ;|tfront=0 tback=huge
  fldz
  mov cx,NPLANES
  lea bx,[bp+si]  ; gem planes are at [bp+200h,300h,...]
G:
  fild word[C16 + si-100h] ; plane 0 has distance 16, others have 32
  cmp cl,NPLANES
  je GNZ
  fadd st0        ;|pd tf tb
GNZ:
; generic ray-plane intersection
  call DOT        ;|D=pn*rd pd tf tb
  xchg bp,dx
  call DOT        ;|pn*ro D pd tf tb
  xchg bp,dx
  fsubp st2,st0   ;|D N=pd-pn*ro
  ftst
  fnstsw ax
  sahf       ; cf=1 if we're in front of the plane
  fdivp st1,st0   ;|t=N/D tf tb
  jnc GBACK
GFRONT:
  fcom st0,st1
  fnstsw ax
  sahf
  jbe GNEXT         ;if t>tf { tf=t; di=hit_address = current; }
  fst st1
  mov di,bx

  shr di,4

  jmp GNEXT
GBACK:
  fcom st0,st2
  fnstsw ax
  sahf
  jae GNEXT        ;if t<tf { tb=t; }
  fst st2
GNEXT:
  fstp st0
  fcom
  fnstsw ax
  sahf              ;if tf>=fb { no_hit: cf=0; early exit } else { cf=1 }
  jae GEXIT
  lea bx,[bx+si] ; don't set flags
  loop G
GEXIT:              ;[di+si] = facehit
  fcompp
  ret

C16 dw 16
C100 dw 100
CG dw 64

;int ray_gem_outer(ray const& r, v3* hitpos) {
;  float tfront=0, tback=INFf; int face=0;
;  for (int ip=0; ip<LEN(p); ip++) {
;    hit h = ray_plane(r, p[ip]);
;    if (h.front) { if (h.t>tfront) { tfront=h.t; face=ip; } }
;    else         { if (h.t<tback) { tback=h.t; } }
;  }
;  if (tfront<tback) {  // hit!
;    *hitpos = r.o + r.d*tfront;
;    return face;
;  }
;  else return -1;
;}

;float ray_gem_inner(ray& r, int face_excluded) {
;  if (depth>depth_max) return ray_background(r);
;  depth++;
;  float t=INFf; int face=0;
;  for (int ip=0; ip<LEN(p); ip++) if (ip != face_excluded) {
;    hit h = ray_plane(r, p[ip]);
;    if (h.t>0 && h.t<t) { t=h.t; face=ip; }
;  }
;
;  v3 hitpos = r.o + r.d*t;
;  float R = fresnel(1.f/ior, r.d|p[face].n);
;  ray rr{hitpos, reflect(r.d, -p[face].n)};
;  float color = R * ray_gem_inner(rr, face);
;  if (R < 1) {
;    ray rt{hitpos, refract(r.d, -p[face].n, ior)};
;    color += (1-R) * ray_background(rt);
;  }
;  depth--;
;  return color * exp(-t * absorptivity_gem);
;}


;Gem planes (normalized) are at [bp+100h], [bp+200h], ...
; nx ny nz  d
;  0  0  1  4
;  1  1  1  8
;  1  1 -1  8
;  1 -1  1  8
;  1 -1 -1  8
; -1  1  1  8
; -1  1 -1  8
;  1 -1  1  8
; -1 -1 -1  8
